'use strict';

(function () {
	var initPayPalButton = function initPayPalButton() {
		var buttonConfiguration = {};
		var phrases = {};

		var productInfoDetails = document.querySelector('div.product-info-details');
		var newbutton = document.createElement('div');
		newbutton.id = 'paypal-newbutton';
		var separator = document.createElement('div');
		separator.id = 'paypal-separator';
		var introLabel = document.createElement('span');
		introLabel.id = 'paypal-introlabel';
		introLabel.innerText = phrases.separatorLabel;
		separator.appendChild(introLabel);
		newbutton.appendChild(separator);
		var ppecs = document.createElement('span'),
		    logoImg = document.createElement('img'),
		    ppImg = document.createElement('img'),
		    pplink = document.createElement('a');
		logoImg.src = buttonConfiguration.logoUrl;
		logoImg.id = 'paypal-logoimg';
		ppImg.src = buttonConfiguration.ppUrl;
		ppImg.id = 'paypal-nameimg';
		ppecs.id = 'paypal-ecsbutton';
		ppecs.style.background = buttonConfiguration.backgroundColor;
		ppecs.style.border = '1px solid ' + buttonConfiguration.borderColor;
		ppecs.appendChild(ppImg);
		ppecs.appendChild(document.createTextNode(' '));
		ppecs.appendChild(logoImg);
		pplink.classList.add('paypal-ecs-button');
		pplink.href = 'shopping_cart.php?display_mode=ecs';
		pplink.addEventListener('click', function (e) {
			var productsId = document.querySelector('#products-id').value,
			    productsQty = document.querySelector('#attributes-calc-quantity').value;
			e.preventDefault();
			document.location = 'shop.php?do=PayPalHub/AddToCart&products_id=' + productsId + '&qty=' + productsQty;
		});
		pplink.append(ppecs);
		newbutton.appendChild(pplink);

		var bc = document.querySelector('div.button-container');
		bc.parentNode.insertBefore(newbutton, bc.nextSibling);
	};

	document.addEventListener('DOMContentLoaded', function () {
		var hasProperties = document.querySelectorAll('div.properties-selection-form').length > 0,
		    hasAttributes = document.querySelectorAll('fieldset.attributes').length > 0,
		    hasCustomizer = document.querySelectorAll('#customizer-form').length > 0,
		    hasFetch = "fetch" in window;

		if (hasFetch && !hasProperties && !hasAttributes && !hasCustomizer) {
			initPayPalButton();
		}
	});
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
